<?php
defined('ABSPATH') or die('Nope, not accessing this');

/*
Plugin Name: Bidding Export
Plugin URI:  http://www.broadwayinfotech.com.au
Description: Creates an interfaces to calculate Bidding Export.
Version:     1.0.0
Author:      Broadway Infotech
License:     Bwit
License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php'; 
    include_once(plugin_dir_path( __FILE__ ) . 'functions.php');
}

class Bid_List extends WP_List_Table
{
    function __construct()
    {
        parent::__construct([
            'singular' => __('wpa_auction', 'upbid2'),
            'plural' => __('wpa_auctions', 'upbid2'),
            'ajax' => false,
        ]);
        
    }   

    public static function getData($per_page = 5, $page_number = 1)
    {

        global $wpdb;

        // $sql = "SELECT id,name,start_price,description FROM {$wpdb->prefix}wpa_auctions";

        $current_offset = get_option('gmt_offset');
        $offsetSec = $current_offset*60*60;
        $offsetFormat = date("H:i", $offsetSec);      
        
       

         $sql = "SELECT auctions.*,posts.guid AS blog_image_url,CONVERT_TZ(bids.date,'+00:00','+".$offsetFormat."') AS bid_date, bids.bidder_name,count(bids.id) as total_bids FROM {$wpdb->prefix}wpa_auctions AS auctions  INNER JOIN {$wpdb->prefix}posts  AS posts ON auctions.image_url = posts.ID LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id GROUP BY auctions.id";

        if (!empty($_REQUEST['orderby'])) {
            $sql .= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
            $sql .= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' ASC';
        }

        $sql .= " LIMIT $per_page";
        $sql .= ' OFFSET ' . ($page_number - 1) * $per_page;
        $result = $wpdb->get_results($sql, 'ARRAY_A'); 

 
        $data = array();
        foreach ($result as $wk_posts) {
            $data[] = array(
                'id' => $wk_posts['id'],
                'name' => $wk_posts['name'],
                'bidder_name' => $wk_posts['bidder_name'],
                'current_price' => $wk_posts['current_price'],
                'total_bids' => $wk_posts['total_bids'],
                'bid_date' => $wk_posts['bid_date']
            );
        }
        return $data;
    }

    public static function delete_customer($id)
    {
        global $wpdb;

        $wpdb->delete(
            "{$wpdb->prefix}wpa_auctions",
            ['id' => $id],
            ['%d']
        );
    }

    public static function record_count()
    {
        global $wpdb;

        $sql = "SELECT count(*) FROM {$wpdb->prefix}wpa_auctions ";
        return $wpdb->get_var($sql);
    }

    public function no_items()
    {
        _e('No records avaliable.', 'auction');
    }

    function column_name($item)
    {
        // create a nonce
        $delete_nonce = wp_create_nonce('upbid2_delete_wpa_auctions');

        $title = '<strong>' . $item['name'] . '</strong>';

        $ajaxCSVUrl= admin_url( 'admin-ajax.php' );

        $actions = [
            'delete' => sprintf('<a href="?page=%s&action=%s&customer=%s&_wpnonce=%s">Delete</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce), 

            'view' => '<a href="javascript:void(0)" class="view-details" data-bs-toggle="modal" data-target1=".bd-example-modal-lg" data-target="#auctionlistmodal" data-id="' . absint($item['id']) . '" data-ajaxurl='.$ajaxCSVUrl.' >View</a>'
        ];

        return $title . $this->row_actions($actions);
    }

    public function column_default($item, $column_name)
    {
        switch ($column_name) {
            case 'name':
            case 'bidder_name':
            case 'current_price':
            case 'total_bids':
            case 'bid_date':
                return $item[$column_name];
            default:
                return print_r($item, true); //Show the whole array for troubleshooting purposes
        }
    }

    function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="bulk-delete[]" value="%s" />',
            $item['id']
        );
    }

    function column_action($item)
    {
        $id = $item['id'];
        $ajaxUrl= admin_url( 'admin-ajax.php' );

        return sprintf(
            "<a href='javascript:void(0);' data-id='".$id."' data-ajaxurl='".$ajaxUrl."' class='customAjax'>Export CSV</a>"
        );
    }

    function get_columns()
    {
        $columns = [
            'cb' => '<input type="checkbox" />',
            'name' => __('Title', 'upbid2'),
            'bidder_name' => __('Bidder Name', 'upbid2'),
            'current_price' => __('Bid Amount', 'upbid2'),
            'total_bids' => __('Total Bids', 'upbid2'),
            'bid_date' => __('Bid Date', 'upbid2'),
            'action' => __('Action', 'upbid2'),
        ];

        return $columns;
    }

    public function get_sortable_columns()
    {
        $sortable_columns = array(
            'name' => array('name', true),
            'bidder_name' => array('bidder_name', false),
            'current_price' => array('current_price', false),
            'total_bids' => array('total_bids', false),
            'bid_date' => array('bid_date', false)
        );

        return $sortable_columns;
    }

    public function get_bulk_actions()
    {
        $actions = [
            'bulk-delete' => 'Delete'
        ];

        return $actions;
    }


    public function prepare_items()
    {

        $this->process_bulk_action(); 

        $per_page = $this->get_items_per_page('wpa_auctions_per_page', 5);
        $current_page = $this->get_pagenum();
        $total_items = self::record_count();

        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        $this->_column_headers = array($columns, $hidden, $sortable);

        $this->set_pagination_args([
            'total_items' => $total_items,
            'per_page' => $per_page
        ]);

        $this->items = self::getData($per_page, $current_page);
    }

    public function process_bulk_action()
    {
        //Detect when a bulk action is being triggered...
        if ('delete' === $this->current_action()) {
            // In our file that handles the request, verify the nonce.
            $nonce = esc_attr($_REQUEST['_wpnonce']);

            if (!wp_verify_nonce($nonce, 'upbid2_delete_wpa_auctions')) {
                die('Go get a life script kiddies');
            } else {
                self::delete_customer(absint($_GET['customer']));

                wp_redirect(esc_url(add_query_arg()));
                exit;
            }

        }

        // If the delete bulk action is triggered
        if (
            (isset($_POST['action']) && $_POST['action'] == 'bulk-delete')
            || (isset($_POST['action2']) && $_POST['action2'] == 'bulk-delete')
        ) {

            $delete_ids = esc_sql($_POST['bulk-delete']);

            // loop over the array of record IDs and delete them
            foreach ($delete_ids as $id) {
                self::delete_customer($id);

            }

            wp_redirect(esc_url(add_query_arg()));
            exit;
        }
    }
 
    public function addscript()
    {
        echo '<script src="'.plugins_url().'/customBid/js/custom-script.js"></script>'; 
    }
}

function my_render_list_page()
{
    echo '<div class="wrap"><h2>Bidding List</h2>'; 

    $list_table = new Bid_List();
    $list_table->prepare_items();  

    $list_table->display();
    echo '</div>';

    $list_table->addscript();

     // Modal HTML Markup
     echo '<div id="auctionlistmodal" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="exampleModalLabel">Bidding Details  <span id="bidding-details-title"></span> </h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body" style=" overflow: auto;  max-height: 100vh !important; scrollbar-width: thin;"></div>
        </div>
    </div>
</div>';
}

function my_add_menu_items()
{
    add_menu_page('My Plugin List Table', 'Bidding List', 'activate_plugins', 'my_list_test', 'my_render_list_page');
}
add_action('admin_menu', 'my_add_menu_items');   