<?php
function enqueue_bootstrap_in_admin() {
    wp_enqueue_style('bootstrap-css', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'enqueue_bootstrap_in_admin');

add_action("wp_ajax_export_csv_action", "get_export_csv");
add_action("wp_ajax_nopriv_export_csv_action", "get_export_csv");

function get_export_csv() {
    global $wpdb; 
 
    $auctionId = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if ($auctionId <= 0) { 
        wp_send_json_error("Invalid or missing auction ID.");
    } 

    $current_offset = get_option('gmt_offset');
    $offsetSec = $current_offset*60*60;
    $offsetFormat = date("H:i", $offsetSec);  
     

     $sql_query = "SELECT auctions.name,auctions.date_end, bids.bidder_name, bids.current_bid_price,CONVERT_TZ(bids.date,'+00:00','+".$offsetFormat."') AS bid_date FROM {$wpdb->prefix}wpa_auctions AS auctions LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id WHERE auctions.id={$auctionId} AND bids.auction_id={$auctionId} ORDER BY bid_date DESC";
    
    $results = $wpdb->get_results($sql_query, ARRAY_A);

    if (empty($results)) { 
        wp_send_json_error("No data found for the specified auction ID.");
    }

    // Set header row values
    $csv_fields = array("Title", "Bidder Name", "Bidding Amount", "Bidding Date");
    $output_filename = 'auction_' . time() . '.csv';

    // Start output buffering
    ob_start();

    $output_handle = fopen('php://output', 'w');

    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Content-Description: File Transfer');
    header('Content-type: text/csv');
    header('Content-Disposition: attachment; filename=' . $output_filename);
    header('Expires: 0');
    header('Pragma: public');
   
    fputcsv($output_handle, $csv_fields);

    foreach ($results as $row) {           
            $data = array( 
                $row['name'],
                $row['bidder_name'],
                $row['current_bid_price'], 
                $row['bid_date']
            ); 
            fputcsv($output_handle, $data);
        } 
   
    fclose($output_handle);
    wp_send_json_success(ob_get_clean());
    die();
}

add_action("wp_ajax_auction_details_action", "get_auction_details");
add_action("wp_ajax_nopriv_auction_details_action", "get_auction_details");

function get_auction_details() { 
    global $wpdb; 
 
    $auctionId = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if ($auctionId <= 0) { 
        wp_send_json_error("");
    }
 
    $current_offset = get_option('gmt_offset');
    $offsetSec = $current_offset*60*60;
    $offsetFormat = date("H:i", $offsetSec);  
        
        
 
    $sql_query = "SELECT auctions.name, bids.bidder_name, bids.current_bid_price,CONVERT_TZ(bids.date,'+00:00','+".$offsetFormat."') AS date FROM {$wpdb->prefix}wpa_auctions AS auctions LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id WHERE auctions.id={$auctionId} AND bids.auction_id={$auctionId} ORDER BY bids.id DESC"; 
    
    $results = $wpdb->get_results($sql_query, ARRAY_A);

 
    if (empty($results)) { 
        wp_send_json_error("");
    }
  
    ob_start();
      echo json_encode($results);

    wp_send_json_success(ob_get_clean());
    die();
}

