(function ($) {
     $(".customAjax").click(function (e) {

          let dataId = $(this).attr("data-id")
          let ajax_url = $(this).attr("data-ajaxurl")

          $.ajax({
               type: 'POST',
               dataType: 'json',
               url: ajax_url,
               data: {
                    action: 'export_csv_action',
                    id: dataId
               },
               cache: false,
               beforeSend: function () {
                    $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
               },
               success: function (response) {

                    var downloadLink = document.createElement("a");
                    var fileData = ['\ufeff' + response.data];

                    var blobObject = new Blob(fileData, {
                         type: "text/csv;charset=utf-8;"
                    });

                    var url = URL.createObjectURL(blobObject);
                    downloadLink.href = url;
                    currentDate = new Date();
                    const timestamp = currentDate.getTime()
                    downloadLink.download = "auction_" + timestamp + ".csv";

                    /*
                     * Actually download CSV
                     */
                    document.body.appendChild(downloadLink);
                    downloadLink.click();
                    document.body.removeChild(downloadLink);

               },
               error: function (errorThrown) {
                    console.log(errorThrown);
               },
               complete: function () {
                    $("#loading").hide();
               }
          });

     })

     $('.view-details').on('click', function () {  
          let auctionId = $(this).data('id');
          let ajaxUrl = $(this).data('ajaxurl');

          $.ajax({
               type: 'POST',
               dataType: 'json',
               url: ajaxUrl,
               data: {
                    action: 'auction_details_action',
                    id: auctionId
               },
               cache: false,
               beforeSend: function () {
                    $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');

                    $("#bidding-details-title").html('')
               },
               success: function (response) {
               let res = response.data;
               let optionText1 = 'No Data Found' 
               let optionText = '' 

               if(res.length > 0){ 
                    let mainData = JSON.parse(response.data); 
                    
                $.each(mainData, function(key, value){ 
                    $("#bidding-details-title").html(" -  "+value.name)

                    optionText += ` 
                    <div class="row" style="border-bottom:1px solid #ddd; padding-block:8px;">     
                         <div class="col-md-6"><strong>Bidder Name</strong></div><div class="col-md-6">${value.bidder_name}</div>  
                    </div>
                    <div class="row" style="border-bottom:1px solid #ddd; padding-block:8px;">       
                         <div class="col-md-6"><strong>Amount</strong></div><div class="col-md-6">${value.current_bid_price}</div> 
                    </div>
                    <div class="row" style="padding-block:8px;">        
                         <div class="col-md-6"><strong>Date</strong></div><div class="col-md-6">${value.date}</div>
                    </div><div class="row" style="border-bottom:5px solid #ddd; padding-block:8px;"></div>`;    
                    }) 
                    $('#auctionlistmodal .modal-body').html(optionText);
               }else{
                    $('#auctionlistmodal .modal-body').html(optionText1);
               }
              
               $('#auctionlistmodal').modal('show');                

               },
               error: function (errorThrown) {
                    console.log(errorThrown);
               },
               complete: function () {
                    $("#loading").hide();
               }
          });
     }) 

})(jQuery)



