$(function(){ 

    $ajax_url = $('input[name="ajax_url"]').val();
    $front_page = $('input[name="front_page"]').val();
    $url = $ajax_url+'/wp-admin/admin-ajax.php';  

    $detail_url = $('input[name="detail_url"]').val();

    if($front_page){
        commonAuctionAjax('live_auction_action', 'live-auction');    
    }
})

 
$(".nav-link").on('click', function(){  
    let slug = $(this).attr("slug");  
    $('input[name="limit"]').val(3);

    let activeTab = $("#activeTab").val();
    if(activeTab !== slug){
        commonAuctionAjax('live_auction_action', slug); 
        $("#activeTab").val(slug);
    }
  
}) 

let commonAuctionAjax = (action, type) => {
    $.ajax({
        type: 'POST',
        //dataType:'json',
        url:  $url,
        data: {
            action: action,
            type:type 
        },
        cache:false,
        beforeSend: function () { 
            $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        }, 
        success: function (data){  
            $('#pills-tabContent').html(data); 
        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () {
            $("#loading").hide();  
        }
    });  
 } 

 $(document).ready(function(){
    $(document).on('click','.show_more',function(){
        let next_auction_id = $(this).attr('id');
        let terms = $(this).attr('terms');  
        let limit = $('input[name="limit"]').val();
        $('input[name="limit"]').val(parseInt(limit)+parseInt(3));
        let new_limit = $('input[name="limit"]').val();
        $('.show_more').hide(); 
         loadMoreAuctionAjax('live_auction_action', terms, new_limit,next_auction_id)
    });
});


$(document).ready(function(){
    $(document).on('click','.show_more_bidding_list',function(){
        let next_auction_id = $(this).attr('id');
        let terms = $(this).attr('terms');  
        let bidding_limit = $('input[name="bidding_limit"]').val();
        $('input[name="bidding_limit"]').val(parseInt(bidding_limit)+parseInt(3));
        let new_limit = $('input[name="bidding_limit"]').val();
        $('.show_more_bidding_list').hide(); 
         loadMoreAuctionBiddingAjax('auction_list_action', terms, new_limit,next_auction_id)
    });
});

 let loadMoreAuctionAjax = (action, type, new_limit,next_auction_id) => {
    $.ajax({
        type: 'POST',
        //dataType:'json',
        url:  $url,
        data: {
            action: action,
            type:type,
            limit: new_limit
        },
        cache:false,
         beforeSend: function () { 
            $('.spinner-border').show(); 
         }, 
        success: function (data){  
            $('#show_more_main'+next_auction_id).remove();            
            $('#pills-tabContent').html(data);  
            $('.spinner-border').hide();  
        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () { 
        }
    });  
 } 

 let loadMoreAuctionBiddingAjax = (action, type, new_limit,next_auction_id) => {
    $.ajax({
        type: 'POST',
        //dataType:'json',
        url:  $url,
        data: {
            action: action,
            type:type,
            limit: new_limit
        },
        cache:false,
         beforeSend: function () { 
            $('.spinner-border').show(); 
         }, 
        success: function (data){  
            $('#show_more_bidding_main'+next_auction_id).remove();            
            $('#pills-tabContent').html(data);  
            $('.spinner-border').hide();  
        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () { 
        }
    });  
 } 

 let homeSearchhAjax = (action, auctionType, category='') => {
    $.ajax({
        type: 'POST',
       // dataType:'json',
        url:  $url,
        data: {
            action: action, 
            type:auctionType,
            category:category
        },
        cache:false,
        beforeSend: function () { 
            $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        }, 
        success: function (data){             
            $('#pills-tabContent').html(data); 
        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () {
            $("#loading").hide();  
        }
    });  
 } 

 let homeSearchhAjax_old = (action, auctionType, category='') => {
    $.ajax({
        type: 'POST',
        dataType:'json',
        url:  $url,
        data: {
            action: action, 
            type:auctionType,
            category:category
        },
        cache:false,
        beforeSend: function () {
            $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        },
        success: function (response){
            let data = response.data; 
            let option_text = '<div class="row g-5">'; 

             $.each(data , function(key, value){ 
                let start_date_object = formatDate(value.date_start);
                let end_date_object =  formatDate(value.date_end);  
 
                let details_url = $detail_url+"?auction_id="+value.id;  
                let elementId = generateID();   
   
               let timer =  getTimer(start_date_object, elementId); 

               let auction_title = truncateString(value.name, 60); 
             
                option_text += `<div class="col-lg-4 col-md-6 position-relative">
                <div class="auction-card">
                <a href="${details_url}" class="stretched-link"></a>
                    <h5 class="my-3"><span style="color: #3997ba;">${auction_title}</span></h5>
                    <div class="imgBox">
                   
                      <img src="${value?.blog_image_url}" alt="" class="img-fluid"> 
                            ${elementId  ? `<div class="dTimer"><h5 id="demo${elementId}"></h5></div>` : ''}
                    
                    </div>
                    <div class="mt-4 mb-3">
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">Start Time</p>
                            </div>
                            <div class="col-7">
                                <p><span>${start_date_object}</span></p>
                            </div>
                        </div>                       
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">End Time</p>
                            </div>
                            <div class="col-7">
                                <p><span>${end_date_object}</span></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">No Of Auctions</p>
                            </div>
                            <div class="col-7">
                                <p><span>${value?.total_bids}</span></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">Auction Type</p>
                            </div>
                            <div class="col-7">
                                <p><span style="text-transform:capitalize">${value?.terms}</span></p>
                            </div>
                        </div>
                    </div> 
                </div>
                </div>`;            
            }) 

            option_text += '</div>';
            $('#pills-tabContent').html(option_text); 
        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () {
            $("#loading").hide();  
        }
    });  
 } 


 function truncateString(str, maxLength) {
    if (str.length > maxLength) {
        return str.substr(0, maxLength - 3) + '...';
    }
    return str;
}
 

function formatDate(inputDateString) {
    // Create a Date object from the input string
    var dateObject = new Date(inputDateString);
  
    // Format the date in the desired format
    var formattedDate = dateObject.toLocaleDateString('en-US', {
      month: 'long',
      day: '2-digit',
      year: 'numeric'
    });
  
    var formattedTime = dateObject.toLocaleTimeString('en-US', {
      hour: '2-digit',
      minute: '2-digit',
      hour12: false
    });
  
    // Combine date and time
    var result = formattedDate + ' ' + formattedTime;
  
    return result;
  }


function getTimer(startTime, elementId) {         
    var countDownDate = new Date(startTime).getTime();     

    // Update the count down every 1 second
    var x = setInterval(function () {
        // Get today's date and time
        var customNow  = new Date().toLocaleString("en-US", {timeZone: "Asia/Kolkata"});
        
        
       // var current_time_timestamp = new Date(customNow).getTime();
        var current_time_timestamp = $("#serverTime").val();
        

        var distance = countDownDate - current_time_timestamp;

        // If the count down is over, write some text 
        if (distance <= 0) {
            document.getElementById("demo" + elementId).innerHTML = "0";
            $("#demo" + elementId).closest('.dTimer').hide();
            clearInterval(x);
        } else {
            $("#demo" + elementId).closest('.dTimer').show();
            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Output the result in an element with id="demo"
            let idElement = document.getElementById('demo' + elementId)

            if (idElement !== null) {
                idElement.innerHTML = days + "D : " + hours + "H : " +
                    minutes + "M : " + seconds + "";
            }
        }
    }, 1000);

    // Owl Carousel
    var owl = $(".fsl-carousel");
    owl.owlCarousel({
        items: 1,
        margin: 10,
        loop: true,
        nav: true,
        navText: [
            '<i class="fa-light fa-chevron-left"></i>',
            '<i class="fa-light fa-chevron-right"></i>'
        ],
    });
    var clc = $(".client-carousel");
    clc.owlCarousel({
        items: 5,
        margin: 10,
        loop: false,
        nav: false,
        navText: [
            '<i class="fa-light fa-chevron-left"></i>',
            '<i class="fa-light fa-chevron-right"></i>'
        ],
    });
}
 

const generateID = ()=> {
    return Math.random().toString(36).slice(2)
 }
  

(function($) {
    $(document).on('click', '.registerbutton1', function()
    { 
      var getVal =	$(this).attr('data-id');
      var modal = document.getElementById("Reg-Form");
      var loginmodal = document.getElementById("login-Form");
        if(getVal=='reg'){ 
        loginmodal.style.display = "block";
        modal.style.display = "none";
        } else if(getVal=='login'){ 
        loginmodal.style.display = "none";
        modal.style.display = "block";
        } 
    });
})(jQuery); 


$(document).ready(function() { 
    $('li:has(.sub-menu)').addClass('has-submenu');  
    $('li.has-submenu > a').attr('href', '#');  
    var isLoggedIn = true; 
     
    $('li.has-submenu > a').each(function() { 
        if (isLoggedIn) {
            $(this).attr({
                'data-bs-toggle': 'modal',
                'data-bs-target': '#exampleModalCenter'
            });
        }
    });
});

$(document).ready(function() {  
    $('#main').find('.um.um-account').addClass('container').addClass('mt-5'); 

    let wpText = $('.wpa-content-text').html()
    $(".dTimers").html(wpText)  
})
 
 
$("#home_search_form").on('submit', function(e){
    e.preventDefault();
    let form_data = $('#home_search_form').serialize(); 

    let redirect_url = $('input[name="ajax_url"]').val().concat('/auction/?', form_data)     
    window.location.href=`${redirect_url}`;
 }) 


 $(document).on('show.bs.modal', '#showInterestModal', function (event) {  
    var button = $(event.relatedTarget);
    var auctionId = button.data('id');    
    var auctionTitle = button.data('title');   
    $('#auction_id_input').val(auctionId); 
    $('#auction_title_input').html(auctionTitle);
    $('#auction_name').val(auctionTitle);
 }); 
   
 function enquiryFormValidation() { 
    jQuery('#enquiry_forms').validate({
        rules: { 
            user_name: {
                required: true
            },
            user_mobile: {
                required: true,
                digits: true,  
                minlength: 10,  
                maxlength: 10 
            },
            user_email: {
                required: true,
                email: true  
            },
            user_message: {
                required: true
            }
        },
        messages: { 
            user_name: {
                required: "Please enter your name"
            },
            user_mobile: {
                required: "Please enter your mobile number",
                digits: "Please enter only digits",
                minlength: "Mobile number must be at least 10 digits",
                maxlength: "Mobile number cannot exceed 10 digits"
            },
            user_email: {
                required: "Please enter your email",
                email: "Please enter a valid email address"
            },
            user_message: {
                required: "Please enter your message"
            }
        },
        errorElement: "span",  
        errorClass: "invalid-feedback",  
        highlight: function(element, errorClass, validClass) {
            $(element).addClass('is-invalid');  
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).removeClass('is-invalid'); 
        },
        errorPlacement: function(error, element) { 
            error.insertAfter(element);
        },
        submitHandler: function(form) { 
            var formData = $(form).serialize(); 
            enquiryFormAjax('enquiry_form_action', formData); 
            return false;  
        }
    }); 
     
    return $('#enquiry_forms').valid();
} 
    
jQuery(document).on('submit', '#enquiry_forms', function(e) {     
    e.preventDefault();  
     if(enquiryFormValidation()) {
        $('#enquiry_forms').submit();  
    } 
}); 

 let enquiryFormAjax = (action, form_data) => {
    $.ajax({
        type: 'POST',
        dataType:'json',
        url:  $url,
        data: {
            action: action,
            data:form_data 
        },
        cache:false,
        beforeSend: function () {  
            $("#auction_id_inputs").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        }, 
        success: function (response){    
            setTimeout(() => {
                $("#msg").html(response.data);
                $("#msg").css("background-color", "green");
                $("#showInterestModal").modal('hide'); 
                commonAuctionAjax('live_auction_action', 'live-auction');  
            }, 2000); 
        },
        error: function (errorThrown){
            console.log(errorThrown);
            $("#showInterestModal").modal('hide');  
        },
        complete: function () {    
            $("#loading").hide();   
         }
    });  
 } 

 jQuery(function(){
    jQuery(".um-field-checkbox-option").html(`By registering, you are confirming that you are at least 18 years old, and that I have read and agree to Thinksalvage.com <a href="./terms-conditions" target="_blank">Terms & Conditions</a> and <a href="./privacy-policy-2" target="_blank">Privacy Policy.</a>`)
 })

 jQuery(function(){
    jQuery(".um-toggle-gdpr").hide()
 })
 

  
 jQuery(document).ready(function(){
    var owl = jQuery(".mySlide1");
      owl.owlCarousel({
        items: 1, 
        autoplay: true,
        loop:true,
        nav: true,
        navText: ["<i class='fa-light fa-chevron-left'></i>", "<i class='fa-light fa-chevron-right'></i>"],
        autoPlaySpeed: 1000,
        autoplayHoverPause: true
    });  
});
 


