$(function(){ 

    $ajax_url = $('input[name="ajax_url"]').val();
    $front_page = $('input[name="front_page"]').val();
    $url = $ajax_url+'/wp-admin/admin-ajax.php';  

    $detail_url = $('input[name="detail_url"]').val();

    if($front_page){
        commonAuctionAjax('live_auction_action', 'live-auction');    
    }
})

 
$(".nav-link").on('click', function(){ 
   // let tab = $(this).attr("id");
    let slug = $(this).attr("slug");    

    let activeTab = $("#activeTab").val();
    if(activeTab !== slug){
        commonAuctionAjax('live_auction_action', slug); 
        $("#activeTab").val(slug);
    }
  
}) 
 
 let commonAuctionAjax = (action, type) => {
    $.ajax({
        type: 'POST',
        dataType:'json',
        url:  $url,
        data: {
            action: action,
            type:type 
        },
        cache:false,
        beforeSend: function () {
            //$('#loading').show();
            $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        }, 
        success: function (response){
            let data = response.data;  
            let option_text = '<div class="row g-5">'; 

             $.each(data , function(key, value){ 
                let start_date_object = formatDate(value.date_start);
                let end_date_object =  formatDate(value.date_end);  
                let auction_id = value.id
 
                let details_url = $detail_url+"?auction_id="+auction_id;  
                let elementId = generateID();   
   
               let timer =  getTimer(value.date_start, elementId); 

               let auction_title = truncateString(value.name, 60); 

                option_text += `<div class="col-lg-4 col-md-6 position-relative">
                <div class="auction-card"> 
                   <div class="position-relative">
                    <a href="${details_url}" class="stretched-link"></a>
                    <h5 class="my-3"><span style="color: #3997ba;">${auction_title}</span></h5>
                    <div class="imgBox">
                   
                      <img src="${value?.blog_image_url}" alt="" class="img-fluid"> 
                            ${elementId  ? `<div class="dTimer" style="display:none"><h5 id="demo${elementId}"></h5></div>` : ''}
                    
                    </div>
                    <div class="mt-4 mb-3">
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">Start Time</p>
                            </div>
                            <div class="col-7">
                                <p><span>${start_date_object}</span></p>
                            </div>
                        </div>                       
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">End Time</p>
                            </div>
                            <div class="col-7">
                                <p><span>${end_date_object}</span></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">No Of Auctions</p>
                            </div>
                            <div class="col-7">
                                <p><span>${value?.total_bids}</span></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">Auction Type</p>
                            </div>
                            <div class="col-7">
                            <p><span style="text-transform:capitalize">${value?.terms}</span></p>
                            </div>
                        </div>
                    </div> 
                    </div>

                        <div class="col-12 d-none">
                        <a class="boxfont text-end text-decoration-none d-block text-end" style="color: #3997ba;cursor:pointer" data-id="${auction_id}"  data-title="${auction_title}" data-bs-toggle="modal" data-bs-target="#showInterestModal" >Show Interest</a>
                        </div> 

                        <div class="modal fade" id="showInterestModal" tabindex="-1" aria-labelledby="exampleModalLabels" aria-hidden="true">
                        <div class="modal-dialog" id="auction_id_inputs">
                        <form action="" method="post" id="enquiry_forms">                       
                            <div class="modal-content">
                            <div class="modal-header">
                               <div class="col-md-11 mt-5"><h2 class="modal-title fs-16 text-center" id="exampleModalLabels">Enquiry Form</h2></div>
                                <span id="msg"></span>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p class="fs-16"><h3><span id="auction_title_input"></span></h3></p> 

                                <input type="hidden" name="auction_id" id="auction_id_input">  

                            <div class="form-group fs-16">
                              <label for="recipient-name" class="col-form-label fs-16">Your Name:</label>
                              <input type="text" class="form-control fs-16" name="user_name" id="user_name">
                            </div>
                            <div class="form-group fs-16">
                              <label for="recipient-name" class="col-form-label">Your Mobile Number:</label>
                              <input type="text" class="form-control fs-16" name="user_mobile" id="user_mobile">
                            </div>
                            <div class="form-group fs-16">
                              <label for="recipient-name" class="col-form-label">Your Email:</label>
                              <input type="text" class="form-control fs-16" name="user_email" id="user_email">
                            </div>
                            <div class="form-group fs-16">
                              <label for="message-text" class="col-form-label">Your Message:</label>
                              <textarea class="form-control fs-16" name="user_message" id="user_message"></textarea>
                            </div>

                            <div class="form-group fs-16"><br/>
                            <label for="message-text" class="col-form-label fs-16"><strong>Helpline</strong>:</label>
                             <p class="fs-16">Name:Atul Halarnkar</p>
                             <p class="fs-16">Email:atul.halarnkar@sealthedeal.co.in</p>
                             <p class="fs-16">Mobile:7338164069</p>
                          </div>  

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>                                
                                <button type="submit"  class="btn btn-primary enquiry_form_btn">Send Query</button>
                            </div>
                            </div>
                          
                        </div>
                        </form>
                        </div>

                </div>
                </div>
                
                `;            
            }) 

            option_text += '</div>';
            $('#pills-tabContent').html(option_text);

        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () {
            $("#loading").hide();  
        }
    });  
 } 



 let homeSearchhAjax = (action, auctionType, category='') => {
    $.ajax({
        type: 'POST',
        dataType:'json',
        url:  $url,
        data: {
            action: action, 
            type:auctionType,
            category:category
        },
        cache:false,
        beforeSend: function () {
            $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        },
        success: function (response){
            let data = response.data; 
            let option_text = '<div class="row g-5">'; 

             $.each(data , function(key, value){ 
                let start_date_object = formatDate(value.date_start);
                let end_date_object =  formatDate(value.date_end);  
 
                let details_url = $detail_url+"?auction_id="+value.id;  
                let elementId = generateID();   
   
               let timer =  getTimer(start_date_object, elementId); 

               let auction_title = truncateString(value.name, 60); 
             
                option_text += `<div class="col-lg-4 col-md-6 position-relative">
                <div class="auction-card">
                <a href="${details_url}" class="stretched-link"></a>
                    <h5 class="my-3"><span style="color: #3997ba;">${auction_title}</span></h5>
                    <div class="imgBox">
                   
                      <img src="${value?.blog_image_url}" alt="" class="img-fluid"> 
                            ${elementId  ? `<div class="dTimer"><h5 id="demo${elementId}"></h5></div>` : ''}
                    
                    </div>
                    <div class="mt-4 mb-3">
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">Start Time</p>
                            </div>
                            <div class="col-7">
                                <p><span>${start_date_object}</span></p>
                            </div>
                        </div>                       
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">End Time</p>
                            </div>
                            <div class="col-7">
                                <p><span>${end_date_object}</span></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">No Of Auctions</p>
                            </div>
                            <div class="col-7">
                                <p><span>${value?.total_bids}</span></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-5">
                                <p class="boxfont">Auction Type</p>
                            </div>
                            <div class="col-7">
                                <p><span style="text-transform:capitalize">${value?.terms}</span></p>
                            </div>
                        </div>
                    </div> 
                </div>
                </div>`;            
            }) 

            option_text += '</div>';
            $('#pills-tabContent').html(option_text); 
        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () {
            $("#loading").hide();  
        }
    });  
 } 


 function truncateString(str, maxLength) {
    if (str.length > maxLength) {
        return str.substr(0, maxLength - 3) + '...';
    }
    return str;
}

function formatDate(inputDateString) {
    // Create a Date object from the input string
    var dateObject = new Date(inputDateString);
  
    // Format the date in the desired format
    var formattedDate = dateObject.toLocaleDateString('en-US', {
      month: 'long',
      day: '2-digit',
      year: 'numeric'
    });
  
    var formattedTime = dateObject.toLocaleTimeString('en-US', {
      hour: '2-digit',
      minute: '2-digit',
      hour12: false
    });
  
    // Combine date and time
    var result = formattedDate + ' ' + formattedTime;
  
    return result;
  }

function calculateDateDifference(startDateString, endDateString) {
    var startDate = new Date(startDateString);
    var endDate = new Date(endDateString);
  
    var timeDifference = Math.abs(endDate - startDate);
  
    var days = Math.floor(timeDifference / (1000 * 60 * 60 * 24));
    var hours = Math.floor((timeDifference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((timeDifference % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((timeDifference % (1000 * 60)) / 1000);
  
    return `${days}D : ${hours}H : ${minutes}M : ${seconds}`;
  }

   function getTimer(startTime, elementId) {
    var countDownDate = new Date(startTime).getTime();     

    // Update the count down every 1 second
    var x = setInterval(function () {
        // Get today's date and time
        var customNow  = new Date().toLocaleString("en-US", {timeZone: "Asia/Kolkata"});
        
        
       // var current_time_timestamp = new Date(customNow).getTime();
        var current_time_timestamp = $("#serverTime").val();
        console.log('current_time_timestamp', current_time_timestamp)

        var distance = countDownDate - current_time_timestamp;

        // If the count down is over, write some text 
        if (distance <= 0) {
            document.getElementById("demo" + elementId).innerHTML = "0";
            $("#demo" + elementId).closest('.dTimer').hide();
            clearInterval(x);
        } else {
            $("#demo" + elementId).closest('.dTimer').show();
            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Output the result in an element with id="demo"
            let idElement = document.getElementById('demo' + elementId)

            if (idElement !== null) {
                idElement.innerHTML = days + "D : " + hours + "H : " +
                    minutes + "M : " + seconds + "";
            }
        }
    }, 1000);

    // Owl Carousel
    var owl = $(".fsl-carousel");
    owl.owlCarousel({
        items: 1,
        margin: 10,
        loop: true,
        nav: true,
        navText: [
            '<i class="fa-light fa-chevron-left"></i>',
            '<i class="fa-light fa-chevron-right"></i>'
        ],
    });
    var clc = $(".client-carousel");
    clc.owlCarousel({
        items: 5,
        margin: 10,
        loop: false,
        nav: false,
        navText: [
            '<i class="fa-light fa-chevron-left"></i>',
            '<i class="fa-light fa-chevron-right"></i>'
        ],
    });
}
 

  const generateID = ()=> {
    return Math.random().toString(36).slice(2)
 }

 function truncateString(str, maxLength) {
    if (str.length > maxLength) {
        return str.substr(0, maxLength - 3) + '...';
    }
    return str;
}
   

(function($) {
    $(document).on('click', '.registerbutton1', function()
    { 
      var getVal =	$(this).attr('data-id');
      var modal = document.getElementById("Reg-Form");
      var loginmodal = document.getElementById("login-Form");
        if(getVal=='reg'){ 
        loginmodal.style.display = "block";
        modal.style.display = "none";
        } else if(getVal=='login'){ 
        loginmodal.style.display = "none";
        modal.style.display = "block";
        } 
    });
})(jQuery); 


$(document).ready(function() { 
    $('li:has(.sub-menu)').addClass('has-submenu');  
    $('li.has-submenu > a').attr('href', '#');  
    var isLoggedIn = true; 
     
    $('li.has-submenu > a').each(function() { 
        if (isLoggedIn) {
            $(this).attr({
                'data-bs-toggle': 'modal',
                'data-bs-target': '#exampleModalCenter'
            });
        }
    });
});

$(document).ready(function() {  
    $('#main').find('.um.um-account').addClass('container').addClass('mt-5'); 

    let wpText = $('.wpa-content-text').html()
    $(".dTimers").html(wpText)  
})
 
 
$("#home_search_form").on('submit', function(e){
    e.preventDefault();
    let form_data = $('#home_search_form').serialize(); 

    let redirect_url = $('input[name="ajax_url"]').val().concat('/auction/?', form_data)     
    window.location.href=`${redirect_url}`;
 }) 


 $(document).on('show.bs.modal', '#showInterestModal', function (event) {  
    var button = $(event.relatedTarget);
    var auctionId = button.data('id');    
    var auctionTitle = button.data('title');   
    $('#auction_id_input').val(auctionId); 
    $('#auction_title_input').html(auctionTitle);
 }); 
   
 function enquiryFormValidation() { 
    $('#enquiry_forms').validate({
        rules: { 
            user_name: {
                required: true
            },
            user_mobile: {
                required: true,
                digits: true,  
                minlength: 10,  
                maxlength: 10 
            },
            user_email: {
                required: true,
                email: true  
            },
            user_message: {
                required: true
            }
        },
        messages: { 
            user_name: {
                required: "Please enter your name"
            },
            user_mobile: {
                required: "Please enter your mobile number",
                digits: "Please enter only digits",
                minlength: "Mobile number must be at least 10 digits",
                maxlength: "Mobile number cannot exceed 10 digits"
            },
            user_email: {
                required: "Please enter your email",
                email: "Please enter a valid email address"
            },
            user_message: {
                required: "Please enter your message"
            }
        },
        errorElement: "span",  
        errorClass: "invalid-feedback",  
        highlight: function(element, errorClass, validClass) {
            $(element).addClass('is-invalid');  
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).removeClass('is-invalid'); 
        },
        errorPlacement: function(error, element) { 
            error.insertAfter(element);
        },
        submitHandler: function(form) { 
            var formData = $(form).serialize(); 
            enquiryFormAjax('enquiry_form_action', formData); 
            return false;  
        }
    }); 
     
    return $('#enquiry_forms').valid();
} 
    
$(document).on('submit', '#enquiry_forms', function(e) { 
    e.preventDefault();  
    if(enquiryFormValidation()) {
        $('#enquiry_forms').submit();  
    }
}); 

 let enquiryFormAjax = (action, form_data) => {
    $.ajax({
        type: 'POST',
        dataType:'json',
        url:  $url,
        data: {
            action: action,
            data:form_data 
        },
        cache:false,
        beforeSend: function () {  
            $("#auction_id_inputs").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        }, 
        success: function (response){    
            setTimeout(() => {
                $("#msg").html(response.data);
                $("#msg").css("background-color", "green");
                $("#showInterestModal").modal('hide'); 
                commonAuctionAjax('live_auction_action', 'live-auction');  
            }, 2000); 
        },
        error: function (errorThrown){
            console.log(errorThrown);
            $("#showInterestModal").modal('hide');  
        },
        complete: function () {    
            $("#loading").hide();   
         }
    });  
 } 


 