<?php
/**
* Template Name:Auction Page
*
*/ 
 get_header(); 

 while ( have_posts() ) :	
				the_post();
			 
              the_content(); 		 

   endwhile;  
		 
   $terms = get_terms([
    'taxonomy' => 'auction_category',
    'hide_empty' => false,
    'orderby'  => 'term_id'
    ]);  

    $locations = getAuctionLocations();   
 
 
$request_type = (isset($_GET['auction_type']) && !empty($_GET['auction_type']))? $_GET['auction_type']:'';
$request_category = (isset($_GET['category']) && !empty($_GET['category']))? $_GET['category']:'';
$request_search = (isset($_GET['search']) && !empty($_GET['search']))? $_GET['search']:'';

 ?>
 <section class=" about-banner d-flex justify-content-center align-items-center">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="text text-center text-white">
                        <h1 class="mb-3"><?php the_title(); ?></h1>
                     </div>
                </div>
            </div>
        </div>
    </section>   
 <section class="pb-0">
    <div class="container">
        <h2 style="margin-top: 14px;">Auctions</h2>
        <form action="" method="post" id="auction_form_filter">
            <div class="row">
                <div class="col-lg"> 
                    <select name="auction_type" id="auction_type" class="form-select py-4 px-3 custom-select-filter">
                        <option value="" selected>Select Type</option>
                        <option value="live-auction" >Live Auctions</option>
                        <option value="upcoming-auction" selected>Upcoming Auctions</option>
                        <option value="past-auction">Past Auctions</option>
                    </select>
                </div>
                <div class="col-lg">
                <select name="auction_category" id="auction_category" class="form-select py-4 px-3 fs-16 custom-select-filter">
                        <option value=""  class="fs-16">Select Category</option>
                        <?php 
                                 $selected ='';
                                if(!empty($terms)) :
                                    foreach($terms as $key => $value):
                                    $selected =   ($value->slug == $request_category)?' selected="selected" ':'';  
                        ?>
                                <option value="<?php echo $value->slug;  ?>" <?php echo $selected; ?>   class="fs-16"><?php echo $value->name;  ?></option> 
                        <?php
                                endforeach;
                            endif; 
                        ?>
                </select>
                </div>
               
                <div class="col-lg">
                    <select name="auction_location" id="auction_location" class="form-select py-4 px-3 custom-select-filter">
                        <option value="" selected>Select Location</option>
                        <?php
                        $selected ='';
                                if(!empty($locations)) :
                                    foreach($locations as $key => $value):
                                   // $selected =   ($value->slug == $request_category)?' selected="selected" ':''; 
                                    ?>
                                <option value="<?php echo $value['shipping_from'];  ?>" <?php echo $selected; ?>   class="fs-16"><?php echo ucfirst($value['shipping_from']);  ?></option> 
                        <?php
                                endforeach;
                            endif; 
                        ?>
                    </select>
                </div>
                <div class="col-lg">
                    <input class="form-control py-4 px-3 custom-select-filter fs-16" type="text" placeholder="Title" name="auction_title" id="auction_title" value="<?php echo $request_search; ?>" /> 
                </div>
                <div class="col-lg"> 
                      <button class="btn bg-mycolor my-nav-btn" type="submit" class="btn">Search</button>
                </div>
            </div>
        </form>
    </div>
</section>

<section class="Auction">
    <div class="container">
        <div class="row">
            <div class="col">
            <div class="tab-content"">
                <div class="row g-5" id="pills-tabContent">
                    <!-- loader -->
                    <div class="text-center">
                        <div class="spinner-border text-dark custom-spinner" role="status" >
                            <span class="sr-only">Loading...</span>
                        </div>
                    </div>              
                    <!-- loader end-->
                    </div>    
                </div>
            </div>
        </div>
    </div>
</section>
 
 <?php 
 get_footer();
?>   
 
<script>

$(function(){ 

    $ajax_url = $('input[name="ajax_url"]').val();
    $request_category = $('input[name="request_category"]').val();
    $request_search = $('input[name="request_search"]').val(); 
    $url = $ajax_url+'/wp-admin/admin-ajax.php';  
     
     
    if($request_search !==''){
        auctionAjax('auction_list_action', 'auction_type=upcoming-auction',  '', $request_search); 
    }else{
        auctionAjax('auction_list_action', 'auction_type=upcoming-auction',  $request_category);  
    }
     
})

$("#auction_form_filter").on('submit', function(e){
    e.preventDefault();
    $('input[name="bidding_limit"]').val(3);                                                                        
    let form_data = $('#auction_form_filter').serialize();
    auctionAjax('auction_list_action', form_data); 
})


let auctionAjax = (action, auctionType, category='', search='') => {
    $.ajax({
        type: 'POST',
       // dataType:'json',
        url:  $url,
        data: {
            action: action, 
            type:auctionType,
            category:category,
            search:search
        },
        cache:false,
        beforeSend: function () {
            $("#pills-tabContent").html('<div class="text-center"><div class="spinner-border text-dark custom-spinner" role="status"><span class="sr-only">Loading...</span></div></div>');
        },
        success: function (data){ 
            $('#pills-tabContent').html(data); 
        },
        error: function (errorThrown){
            console.log(errorThrown);
        },
        complete: function () {
            $("#loading").hide();  
        }
    });  
 } 


 function truncateString(str, maxLength) {
    if (str.length > maxLength) {
        return str.substr(0, maxLength - 3) + '...';
    }
    return str;
}
</script>

 