<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

 if(is_active_sidebar('company-logo')):
    dynamic_sidebar('company-logo'); 
endif; 

if(is_active_sidebar('bottom-contact')):
    dynamic_sidebar('bottom-contact'); 
endif; 
     
$request_type = (isset($_GET['auction_type']) && !empty($_GET['auction_type']))? $_GET['auction_type']:'';
$request_category = (isset($_GET['category']) && !empty($_GET['category']))? $_GET['category']:'';
$request_search = (isset($_GET['search']) && !empty($_GET['search']))? $_GET['search']:'';
?> 

<footer>
        <div class="container">
            <div class="row">
                <div class="col-lg-2">
                    <div class="footerBox">
                        <div class="d-flex justify-content-lg-start justify-content-center">
                        <a href="<?php echo home_url(); ?>"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/footerLogo.png" alt="logo" class="img-fluid"></a>
                        </div>

                    </div>
                </div>
                <div class="col-lg-10 align-self-center">
                    <div class="footerBox2 d-xl-flex justify-content-lg-between">
                    <nav class="main-nav">
                  <?php  
                    $args = array(
                    'container'      => '',
                    'theme_location' => 'footer',
                    'depth'          => 1,
                    'fallback_cb'    => false,
                    'menu_class'     => 'footerUL d-flex'
                    );

                    wp_nav_menu($args);
                  ?>
                </nav>
                       <!--  <ul class="footerUL d-flex">
                            <li>
                                <a class="nav-link" href="#">Home</a>
                            </li>
                            <li>
                                <a class="nav-link" href="#">About Us</a>
                            </li>
                            <li>
                                <a class="nav-link" href="#">Auction</a>
                            </li>
                            <li>
                                <a class="nav-link" href="#">Classified</a>
                            </li>
                            <li>
                                <a class="nav-link" href="#">Contact Us</a>
                            </li>

                        </ul> -->
                       
                        <?php 
                            if(is_active_sidebar('social-widget-area')):
                            dynamic_sidebar('social-widget-area'); 
                            endif; 
                        ?>
                    </div>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-lg-4 text-lg-start text-center">
                    <?php 
                        if(is_active_sidebar('footer-contact-number')):
                         dynamic_sidebar('footer-contact-number'); 
                        endif; 
                     ?>
                </div>
                <div class="col-lg-12 text-center">
                <?php 
                        if(is_active_sidebar('footer-copyright')):
                         dynamic_sidebar('footer-copyright'); 
                         endif; 
                ?> 
                </div>
            </div>
        </div>
    </footer> 
      	                     
    <input type="hidden" name="auction_type" value="<?php  echo $request_type; ?>"/>		
    <input type="hidden" name="request_category" value="<?php  echo $request_category; ?>"/>		
    <input type="hidden" name="request_search" value="<?php  echo $request_search; ?>"/>	 
    <input type="hidden" name="front_page" value="<?php echo is_front_page(); ?>"/>		
    <input type="hidden" name="ajax_url" value="<?php echo bloginfo('url'); ?>" />
    <input type="hidden" name="detail_url" value="<?php echo get_permalink('14'); ?>" />
      
    <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/bootstrap.bundle.min.js"></script> 

 
   <!-- Modal -->
   <div class="modal fade ana-modal" id="exampleModalCenter"  tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="mx-auto modal-dialog-centered modal-dialog" role="document" style="max-width:500px">
    <div class="modal-content">
      <div class="modal-body" id="login-Form"> 

      <div class="modal-header">
        <h5 class="modal-title text-center">Login Form</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>   
        <?php echo do_shortcode('[ultimatemember form_id="102"]'); ?>
      </div>
      <div class="modal-body" id="Reg-Form">

      <div class="modal-header">
        <h5 class="modal-title text-center">Create Your account</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>  

        <?php echo do_shortcode('[ultimatemember form_id="101"]'); ?>    
      </div>
      <div class="modal-body" id="forgot-Form">

       <div class="modal-header">
        <h5 class="modal-title text-center">Forgot Password</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>  
      
        <?php echo do_shortcode('[ultimatemember_password]'); ?>    
      </div>
    </div>
  </div>
</div>
<div class="modal fade ana-modal" id="exampleModalCenterregister" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="mx-auto modal-dialog-centered" role="document" style="max-width:550px">
    <div class="modal-content">
      <div class="modal-body">
      <h5 class="modal-title heading_title" id="exampleModalLongTitle">Book appointment</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
        <?php echo do_shortcode('[ultimatemember form_id="306"]'); ?>    
      </div>
    </div>
  </div>
</div>

</div><!-- #page -->

<div class="modal" tabindex="-1" role="dialog" id="forgotalert" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Forgot Password Reset</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>Your Password Successfully update please got to login button.</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary">Save changes</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<input type="hidden" id="serverTime" value="">
    <?php 
    $current_offset = get_option('gmt_offset');
    $currentTime = time()+$current_offset*60*60;
    $todayDate = date("Y-m-d H:i:s", $currentTime);
?>

  
<?php wp_footer(); ?>

    <script>
       
  function checkTime(i) {
    if (i<10)
    {
      i = "0" + i;
     return i;
    }
    else
    {
      return i;
    }   
}
var today=new Date('<?php echo date($todayDate, time())?>');
 

function startTime() {

  today.setSeconds(today.getSeconds()+1)
    var year=today.getFullYear();
    var month=today.getMonth()+1;
    var day=today.getDate();
    var hour=today.getHours();
    var minute=today.getMinutes();
    var second=today.getSeconds();
    day = checkTime(day);
    minute = checkTime(minute);
    second = checkTime(second);
    month = checkTime(month);
    var time = year+"-"+month+"-"+day+" "+hour+":"+minute+":"+second;
    console.log("time", time)
    $('#serverTime').val(new Date(time).getTime());
    }

    $(document).ready(function () {
      setInterval(startTime, 990);
    });
  
      

 jQuery(".thumbnail").on("click", function () {
        var clicked = $(this);
        var newSelection = clicked.data("big");
        var $img = $(".primary").css(
          "background-image",
          "url(" + newSelection + ")"
        );
        clicked.parent().find(".thumbnail").removeClass("selected");
        clicked.addClass("selected");
        $(".primary").empty().append($img.hide().fadeIn("slow"));
      });
    </script>
</body>

</html>