<?php
// Your code to enqueue parent theme styles
//get_template_directory_uri(); get_stylesheet_directory_uri
function enqueue_parent_styles()
{
    wp_enqueue_style(
        'child-style',
        get_stylesheet_uri(),
        array('twenty-twenty-one-style'),
        wp_get_theme()->get('Version')
    ); 

   // wp_enqueue_script('jquery-validation', get_stylesheet_directory_uri() . '/assets/js/ajax_validation.js', array('jquery'), '1.0', true);
   // wp_enqueue_script('child-style', get_stylesheet_directory_uri() . '/assets/js/common.js', array('jquery'), '1.0', true);

    
}
add_action('wp_enqueue_scripts', 'enqueue_parent_styles');

function add_script()
{ 
     wp_register_script('jquery-min', get_stylesheet_directory_uri() . '/assets/js/jquery.min.js', array('jquery'), 1.0, true);
     wp_enqueue_script('jquery-min');     
     
     wp_register_script('lightboxscript', get_stylesheet_directory_uri() . '/assets/lightbox/js/lightbox-plus-jquery.min.js', array('jquery'), 1.0, true);
     wp_enqueue_script('lightboxscript');  
 
     wp_register_script('carousel', get_stylesheet_directory_uri() . '/assets/js/owl.carousel.min.js', array('jquery'), 1.0, true);
     wp_enqueue_script('carousel'); 

     wp_register_script('bootstrap', get_stylesheet_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('bootstrap'), 1.0, true);
     wp_enqueue_script('bootstrap'); 

     wp_enqueue_script('child-style', get_stylesheet_directory_uri() . '/assets/js/common.js', array('jquery'), '1.0', true);  
 
}
add_action('wp_enqueue_scripts', 'add_script');

function get_main_home_url()
{
    return get_stylesheet_directory_uri();
}
add_shortcode('HOME_URL', 'get_main_home_url');

function return_site_url()
{
    $site_url = site_url();
    return $site_url;
}
add_shortcode('SITE_URL', 'return_site_url');
add_filter('widget_text', 'do_shortcode');


/**
 *	
 * Widgets
 *
 */

function wpb_widgets_init()
{

    register_sidebar(
        array(
            'name' => __('Footer Contact Number', 'widgets'),
            'id' => 'footer-contact-number',
            'description' => __('Add email Id with contact number', 'widgets'),
            'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h6 class="widget-title d-none">',
            'after_title' => '</h6>',
        )
    );

    register_sidebar(
        array(
            'name' => __('Footer Copyright', 'widgets'),
            'id' => 'footer-copyright',
            'description' => __('Add copyright here', 'widgets'),
            'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title d-none">',
            'after_title' => '</h3>',
        )
    );

    register_sidebar(
        array(
            'name' => __('Social Media', 'widgets'),
            'id' => 'social-widget-area',
            'description' => __('The second footer widget area', 'widgets'),
            'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title d-none">',
            'after_title' => '</h3>',
        )
    );

    register_sidebar(
        array(
            'name' => __('Company Logo', 'widgets'),
            'id' => 'company-logo',
            'description' => __('This shows in bottom of company logo', 'widgets'),
            'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title d-none">',
            'after_title' => '</h3>'
        )
    );

    register_sidebar(
        array(
            'name' => __('Bottom Contact', 'widgets'),
            'id' => 'bottom-contact',
            'description' => __('This shows in bottom of page', 'widgets'),
            'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title d-none">',
            'after_title' => '</h3>'
        )
    );

    register_sidebar(
        array(
            'name' => __('Find Out Now', 'widgets'),
            'id' => 'find-out-now',
            'description' => __('This shows in upper of company logo', 'widgets'),
            'before_widget' => '<section id="%1$s" class="Find-out pt-0">',
            'after_widget' => '</section>',
            'before_title' => '<h3 class="widget-title d-none">',
            'after_title' => '</h3>'
        )
    );


    register_sidebar(
        array(
            'name' => __('Slider', 'widgets'),
            'id' => 'slider-count',
            'description' => __('This shows in after how its works section', 'widgets'),
            'before_widget' => '<section id="%1$s" class="Slider-count">',
            'after_widget' => '</section>',
            'before_title' => '<h3 class="widget-title d-none">',
            'after_title' => '</h3>'
        )
    );
}
add_action('widgets_init', 'wpb_widgets_init');

/**
 *	
 * Auction Type
 *
 */

function getActionType()
{
    /* $terms = get_terms([
     'taxonomy' => 'auction_category',
     'hide_empty' => false,
     'orderby'  => 'term_id'
     ]);  */
    $terms = getAuctionType();



    $tab_style_Arr = ['border-radius: 3rem 0 0 3rem', 'border-radius: 0', 'border-radius: 0 3rem 3rem 0'];

    if (empty($terms))
        return false;

    $text_data = '<div class="col">
                    <ul class="nav nav-pills d-flex  justify-content-between" id="pills-tab" role="tablist">';

    $count = 1;
    $c = 0;
    
    foreach ($terms as $key => $value) {

        $active = "";
         
       
        if ($count == 1) {
            $active = "active";  
        } 
 
        $text_data .= '<li class="nav-item" role="presentation">
                                <button class="nav-link ' . $active . ' " slug="' . $key . '" activeData="" style="' . $tab_style_Arr[$c] . '" id="pills-home-tab' . $count . '" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">' . $value . '</button>
                            </li>';
        $count++;
        $c++;
    }
    $text_data .= '<input type="hidden" id="activeTab" value="" />';
    $text_data .= '</ul>
                    <div class="tab-content"">
                        <div class="row g-5" id="pills-tabContent">
                            <!-- loader -->
                            <div class="text-center">
                                <div class="spinner-border text-dark custom-spinner" role="status" >
                                     <span class="sr-only">Loading...</span>
                                </div>
                            </div>              
                            <!-- loader end-->
                            </div>
                    </div></div>';

    return $text_data;

}
add_shortcode('ACTION_TYPES', 'getActionType');

function fn_home_page_action()
{
    return do_shortcode("[ACTION_TYPES]");
}
add_shortcode('home_page_action', 'fn_home_page_action');


/**
 *	
 * Auction Type Live List
 *
 */

add_action("wp_ajax_live_auction_action", "get_auction_type_live_list");
add_action("wp_ajax_nopriv_live_auction_action", "get_auction_type_live_list");

function get_auction_type_live_list()
{
    global $wpdb;
    $terms = $_POST['type'];
    $showLimit = (isset($_POST['limit']) && !empty($_POST['limit'])) ? $_POST['limit'] : 3;     

    $current_date = new DateTime();

    $current_offset = get_option('gmt_offset');
    $offsetSec = $current_offset*60*60;
    $offsetFormat = date("H:i", $offsetSec); 

    $grltTag = '1';
    if ($terms === 'live-auction') {
        $grltTag = "auctions.date_start <= '" . $current_date->format('Y-m-d H:i:s') . "' AND auctions.date_end >= '" . $current_date->format('Y-m-d H:i:s') . "'";
    } else if ($terms === 'upcoming-auction') {
        $grltTag = "auctions.date_start >= '" . $current_date->format('Y-m-d H:i:s') . "'";
    } else {
        $grltTag = "auctions.date_end <= '" . $current_date->format('Y-m-d H:i:s') . "'"; 
    }  
     
    $selectQur = "SELECT auctions.*,posts.guid AS blog_image_url, count(bids.id) as total_bids,CONVERT_TZ(auctions.date_start,'+00:00','+".$offsetFormat."') AS date_start,CONVERT_TZ(auctions.date_end,'+00:00','+".$offsetFormat."') AS date_end FROM {$wpdb->prefix}wpa_auctions AS auctions  LEFT JOIN {$wpdb->prefix}posts  AS posts ON auctions.image_url = posts.ID LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id WHERE  " . $grltTag . "   GROUP BY auctions.id ORDER BY auctions.date_start desc LIMIT $showLimit ";
 
    $selectQurCount = "SELECT auctions.id FROM {$wpdb->prefix}wpa_auctions AS auctions  LEFT JOIN {$wpdb->prefix}posts  AS posts ON auctions.image_url = posts.ID LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id WHERE  " . $grltTag . "   GROUP BY auctions.id ORDER BY auctions.date_start desc";
    $wpdb->get_results($selectQurCount, ARRAY_A); 
    $total_count = $wpdb->num_rows;   
     
 
    $live_results = $wpdb->get_results($selectQur, ARRAY_A);      
   
    $option_text = '';
    if(count($live_results) > 0) {       
        foreach($live_results as $key => $value){         
            
            $auction_title = (strlen($value['name']) >=60)?substr($value['name'],0, 60).'...':$value['name'];
    
            $start_date_object = date('M d, Y H:i',strtotime($value['date_start']));
            $end_date_object = date('M d, Y H:i',strtotime($value['date_end'])); 
            $auction_id = $value['id'];
            $details_url = get_permalink('14').'?auction_id='.$auction_id;
            $total_bids = $value['total_bids'];
            $auction_type = $value['terms'];
            $shipping_from = (isset($value['shipping_from']) && !empty($value['shipping_from'])) ? ucfirst($value['shipping_from']):'N/A' ;
            
            $featuredImage = wp_get_attachment_image_src($value['image_url'], 'medium')[0];  

            $p = '';
            $p .="<script>";        
            $p .="$(document).ready(function() {"; 
            $p .="   let timer =  getTimer('".$value['date_start']."', '".$auction_id."');"; 
            $p .="});"   ;
            $p .="</script>";
            echo $p; 
                

            $elementId_exitst = $auction_id ? '<div class="dTimer" style="display:none"><h5 id="demo'.$auction_id.'"></h5></div>':'';

            $option_text .= '<div class="col-lg-4 col-md-6 position-relative">
                    <div class="auction-card"> 
                    <div class="position-relative">
                        <a href="'.$details_url.'" class="stretched-link"></a>
                        <h5 class="my-3"><span style="color: #3997ba;">'.$auction_title.'</span></h5>
                        <div class="imgBox">
                    
                        <img src="'.$featuredImage.'" alt="" class="img-fluid">'. 
                                $elementId_exitst.'                    
                        </div>
                        <div class="mt-4 mb-3">
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">Start Time </p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$start_date_object.'</span></p>
                                </div>
                            </div>                       
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">End Time</p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$end_date_object.'</span></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">No Of Auctions</p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$total_bids.'</span></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">Auction Type</p>
                                </div>
                                <div class="col-7">
                                <p><span style="text-transform:capitalize">'.$auction_type.'</span></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">Location</p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$shipping_from.'</span></p>
                                </div>
                            </div>
                        </div> 
                        </div>';

                    if($terms == 'upcoming-auction'){ 
                        $option_text .= '<div class="col-12">
                            <a class="boxfont text-end text-decoration-none d-block text-end" style="color: #3997ba;cursor:pointer" data-id="'.$auction_id.'"  data-title="'.$auction_title.'" data-bs-toggle="modal" data-bs-target="#showInterestModal" >Show Interest</a>
                            </div>';
                        }

               $option_text .= '</div>
                    </div>';
        } 
        if($total_count  > $showLimit){
                $option_text.='
                <div class="show_more_main" id="show_more_main"'.$auction_id.'">
                    <div class="d-flex justify-content-center align-items-center">
                        <span id="'.$auction_id.'" terms="'.$terms.'" class="show_more btn bg-mycolor my-nav-btn" title="Load more posts">Show more</span>
                    </div>
                    <div class="text-center">
                                <div class="spinner-border text-dark custom-spinner" role="status" style="display:none" >
                                     <span class="sr-only">Loading...</span>
                                </div>
                            </div>  
                   
                </div>'; 
      }
    } 
    if ($live_results) {
        echo $option_text;
    } else {
        echo $option_text;
    }
    exit;
}

/**
 *	
 * Auction List Page
 *
 */
add_action("wp_ajax_auction_list_action", "get_auction_list");
add_action("wp_ajax_nopriv_auction_list_action", "get_auction_list");

function get_auction_list()
{
    global $wpdb;
    $terms = $_POST['type'];
    $showLimit = (isset($_POST['limit']) && !empty($_POST['limit'])) ? $_POST['limit'] : 3;   
    $category = $_POST['category'];
    $search = $_POST['search'];
    parse_str($terms, $searcharray); 

    $auction_cat = $searcharray['auction_category'];
    $auction_type = $searcharray['auction_type'];
    $auction_location = $searcharray['auction_location'];
    $auction_title = $searcharray['auction_title']; 
 
    $current_date = new DateTime();  
    $current_offset = get_option('gmt_offset');
    $offsetSec = $current_offset*60*60;
    $offsetFormat = date("H:i", $offsetSec);  
 
    $grltTag = '';
    if ($auction_type === 'live-auction') {
        $grltTag = " AND auctions.date_start <= '" . $current_date->format('Y-m-d H:i:s') . "' AND auctions.date_end >= '" . $current_date->format('Y-m-d H:i:s') . "'";
    } else if ($auction_type === 'upcoming-auction') {
        $grltTag = " AND auctions.date_start >= '" . $current_date->format('Y-m-d H:i:s') . "'";
    } else if ($auction_type === 'past-auction') {
        $grltTag = " AND auctions.date_end <= '" . $current_date->format('Y-m-d H:i:s') . "'";
    }
 
    $queryWhreCond = '';
    if (!empty($auction_type) && isset($auction_type)) {
        $queryWhreCond .= $grltTag;
    }
    if (!empty($auction_cat) && isset($auction_cat)) {
        $queryWhreCond .= " AND  auctions.terms = '" . $auction_cat . "'";
    }

    if (!empty($search) && isset($search)) {
        $queryWhreCond .= " AND  auctions.name LIKE '%" . $search . "%'";
    }

    if (!empty($auction_title) && isset($auction_title)) {
        $queryWhreCond .= " AND  auctions.name LIKE '%" . $auction_title . "%'";
    }

    if (!empty($auction_location) && isset($auction_location)) {
        $queryWhreCond .= " AND  auctions.shipping_from LIKE '%" . $auction_location . "%'";
    }

    if (!empty($category) && isset($category)) {
        $queryWhreCond .= " AND  auctions.terms = '" . $category . "'";
    }

    $selectQur = "SELECT auctions.*,posts.guid AS blog_image_url, count(bids.id) as total_bids,CONVERT_TZ(auctions.date_start,'+00:00','+".$offsetFormat."') AS date_start,CONVERT_TZ(auctions.date_end,'+00:00','+".$offsetFormat."') AS date_end FROM {$wpdb->prefix}wpa_auctions AS auctions  LEFT JOIN {$wpdb->prefix}posts  AS posts ON auctions.image_url = posts.ID LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id WHERE 1  " . $queryWhreCond . "  GROUP BY auctions.id ORDER BY auctions.date_start desc  LIMIT $showLimit";  

    $selectQurCount = "SELECT auctions.id FROM {$wpdb->prefix}wpa_auctions AS auctions  LEFT JOIN {$wpdb->prefix}posts  AS posts ON auctions.image_url = posts.ID LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id WHERE 1  " . $queryWhreCond . "  GROUP BY auctions.id ORDER BY auctions.date_start desc"; 
    $wpdb->get_results($selectQurCount, ARRAY_A); 
    $total_count = $wpdb->num_rows;  

    $total_count = $wpdb->get_var($selectQurCount);
    $auction_results = $wpdb->get_results($selectQur, ARRAY_A);    
 
    $option_text = '';
    if(count($auction_results) > 0) { 
        foreach($auction_results as $key => $value){           
            
            $auction_title = (strlen($value['name']) >=60)?substr($value['name'],0, 60).'...':$value['name'];
    
            $start_date_object = date('M d, Y H:i',strtotime($value['date_start']));
            $end_date_object = date('M d, Y H:i',strtotime($value['date_end'])); 
            $auction_id = $value['id'];
            $details_url = get_permalink('14').'?auction_id='.$auction_id;
            $total_bids = $value['total_bids'];
            $auction_cat = $value['terms'];   
            $shipping_from = (isset($value['shipping_from']) && !empty($value['shipping_from'])) ? ucfirst($value['shipping_from']):'N/A' ;         
            
            $featuredImage = wp_get_attachment_image_src($value['image_url'], 'medium')[0];   
 
            $p = '';
            $p .="<script>";        
            $p .="$(document).ready(function() {"; 
            $p .="   let timer =  getTimer('".$value['date_start']."', '".$auction_id."');"; 
            $p .="});"   ;
            $p .="</script>";
            echo $p; 
                

            $elementId_exitst = $auction_id ? '<div class="dTimer" style="display:none"><h5 id="demo'.$auction_id.'"></h5></div>':'';

            $option_text .= '<div class="col-lg-4 col-md-6 position-relative">
                    <div class="auction-card"> 
                    <div class="position-relative">
                        <a href="'.$details_url.'" class="stretched-link"></a>
                        <h5 class="my-3"><span style="color: #3997ba;">'.$auction_title.'</span></h5>
                        <div class="imgBox">
                    
                        <img src="'.$featuredImage.'" alt="'.$auction_title.'" class="img-fluid">'. 
                                $elementId_exitst.'                    
                        </div>
                        <div class="mt-4 mb-3">
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">Start Time</p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$start_date_object.'</span></p>
                                </div>
                            </div>                       
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">End Time</p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$end_date_object.'</span></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">No Of Auctions</p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$total_bids.'</span></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">Auction Type</p>
                                </div>
                                <div class="col-7">
                                <p><span style="text-transform:capitalize">'.$auction_cat.'</span></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-5">
                                    <p class="boxfont">Location</p>
                                </div>
                                <div class="col-7">
                                    <p><span>'.$shipping_from.'</span></p>
                                </div>
                                </div>
                        </div> 
                        </div>';

                    if($auction_type == 'upcoming-auction'){ 
                        $option_text .= '<div class="col-12">
                            <a class="boxfont text-end text-decoration-none d-block text-end" style="color: #3997ba;cursor:pointer" data-id="'.$auction_id.'"  data-title="'.$auction_title.'" data-bs-toggle="modal" data-bs-target="#showInterestModal" >Show Interest</a>
                            </div>';
                        }

                $option_text .= '</div>
                </div>';
            }
          
            if($total_count  > $showLimit){
                $option_text.='
                <div class="show_more_bidding_main" id="show_more_bidding_main"'.$auction_id.'">
                <div class="d-flex justify-content-center align-items-center">    
                    <span id="'.$auction_id.'" terms="'.$terms.'" class="show_more_bidding_list  btn bg-mycolor my-nav-btn" title="Load more posts">Show more</span>
                </div>    
                <div class="text-center">
                                <div class="spinner-border text-dark custom-spinner" role="status" style="display:none" >
                                     <span class="sr-only">Loading...</span>
                                </div>
                            </div>   
                </div>'; 
       } 
    }        
    if ($auction_results) {
        echo $option_text;
    } else {
        echo $option_text;
    }
    exit;
}

/**
 *	
 * Auction Types
 *
 */
function getAuctionType()
{
    $auctionArr = [
        'live-auction' => 'Live Auctions',
        'upcoming-auction' => 'Upcoming Auctions',
        'past-auction' => 'Past Auctions'
    ];
    return $auctionArr;
}


/**
 *	
 * To add the register link in login page
 *
 */
add_action('um_after_form', 'my_um_after_form', 10, 4);
function my_um_after_form($arg)
{

    if ($arg['mode'] == 'login') {
        $strHtml = '<div class="um-col-alt"><div class="um-right">';
        $strHtml .= "Don't have an account? ";
        $strHtml .= '<a href="' . get_permalink() . 'register" class="um-alt registerbutton" data-id="login">Register here for free</a> <br /> ';
        $strHtml .= '<a href="' . wp_lostpassword_url() . '" class="um-alt lostpassword" data-id="login">Forgot Password?</a>';
        $strHtml .= '</div></div>';
    } else {
        $strHtml = '';
        // if(!is_user_logged_in()){
        //$strHtml = '<div class="um-col-alt"><div class="um-right">Already have an account? <a href="javascript:void(0)" class="um-alt registerbutton" data-id="reg">Sign In</a>
        // </div></div>';
        //}
    }

    echo $strHtml;
}

/**
 *	
 * To add profile photo when register user
 *
 */
function um_predefined_fields_hook_profile_photo($arr)
{

    $arr['register_profile_photo'] = array(
        'title' => __('Profile Photo', 'ultimate-member'),
        'metakey' => 'register_profile_photo',
        'type' => 'image',
        'label' => __('Change your profile photo', 'ultimate-member'),
        'upload_text' => __('Upload your photo here', 'ultimate-member'),
        'icon' => 'um-faicon-camera',
        'crop' => 1,
        'editable' => 1,
        'max_size' => (UM()->options()->get('profile_photo_max_size')) ? UM()->options()->get('profile_photo_max_size') : 999999999,
        'min_width' => str_replace('px', '', UM()->options()->get('profile_photosize')),
        'min_height' => str_replace('px', '', UM()->options()->get('profile_photosize')),
    );

    return $arr;

}
add_filter('um_predefined_fields_hook', 'um_predefined_fields_hook_profile_photo', 99999, 1);


/**
 *	
 * To customize the Menu
 *
 */

function customize_menu_objects($items, $args)
{
    foreach ($items as $item) {
        $item->title = '<span>' . $item->title . '</span>';
    }
    return $items;
}
add_filter('wp_nav_menu_objects', 'customize_menu_objects', 10, 2);


/**
 *	
 * To add the childeren Menu
 *
 */
class Custom_Walker_Nav_Menu extends Walker_Nav_Menu
{
    function start_lvl(&$output, $depth = 0, $args = null)
    {
        $indent = str_repeat("\t", $depth);
        $output .= "$indent<ul class=\"sub-menu custom-sub-menu\">\n";
    }
}

/*
 * Remove Profile Image Header
 */
add_action("um_before_profile_form_is_loaded", "remove_profile_header");
function remove_profile_header($args)
{
    remove_action('um_profile_header_cover_area', 'um_profile_header_cover_area', 9);
    // remove_action( 'um_profile_header', 'um_profile_header', 9 );
    remove_action('um_profile_menu', 'um_profile_menu', 9);
}


/*
 *  Home Search Form
 */

function to_show_home_search_form()
{
    return '<div class="search-form"><form action="/auction" method="post" class="input-group mb-3 searchbox" id="home_search_form"><input class="form-control" name="search" type="text" placeholder="Search Motors , Non Motors...." aria-label="Search" aria-describedby="button-addon2" />
<button id="button-addon2" class="btn bg-mycolor SearchBtn home_seach_btn" type="submit"><i class="fa-light fa-magnifying-glass"></i> Search</button></form></div>';
}
add_shortcode('HOME_SEARCH_FORM', 'to_show_home_search_form');


/*
 *  Testimonials
 */

function show_testimonials()
{
    $loop = new WP_Query(
        array(
            'post_type' => 'testimonial',
            'order_by' => 'ID',
        )
    );

    if ($loop->have_posts()) {
        $output = '';
        $count = 1;
        $c = 0;
        while ($loop->have_posts()) {
            $loop->the_post();

            $active = "";
            if ($count == 1) {
                $active = "active";
            }

            $featuredImage = '';
            if (has_post_thumbnail()) {
                $featuredImage = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium');
                $featuredImage = $featuredImage[0];
            }

            $output .= '
            <div class="carousel-item ' . $active . '" data-bs-interval="10000"> 
                                    <div class="MINHeight-Find">
                                        <div class="d-block">
                                            <h3>' . get_the_title() . '</h3>
                                            <h6 class="mt-3">' . get_the_content() . '</h6>
                                            <div class="d-flex align-items-center mt-4">
                                                <img src="' . esc_url($featuredImage) . '" class="imgthumb" alt="...">
                                                <div class="boxDIVdiv align-self-center">
                                                    <h5><span>' . get_field('author') . '</span></h5>
                                                    <p><i>' . get_field('designation') . '</i>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                </div> 
            ';
            $count++;
            $c++;
        }
    }

    return $output;
}

function fn_show_testimonials()
{
    return show_testimonials();
}
add_shortcode('show_testimonials', 'fn_show_testimonials');

/*
 *  Sliders
 */

function show_sliders()
{
    $loop = new WP_Query(
        array(
            'post_type' => 'slider',
            'order_by' => 'ID',
            'order' => 'ASC',
        )
    );

    if ($loop->have_posts()) {
        $output = '';
       
        while ($loop->have_posts()) {
            $loop->the_post(); 

            $featuredImage = '';
            if (has_post_thumbnail()) {
                $featuredImage = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium');
                $featuredImage = $featuredImage[0];
            }

            $output .= '
            <div class="item position-relative">
                <img class="d-block w-100 imgHeight" src="'.esc_url($featuredImage) .'" alt="slide1" />
                <div class="caro-caption position-absolute">
                &nbsp;
                <h5 class="slideH5">' . get_the_title() . '</h5>
                <div class="slideContent mt-4">
                <h3>' . get_the_content() . '</h3>
                </div>
                <a href="'.home_url('contact-us').'" class="btn bg-mycolor my-aboutsec-btn my-4" >Learn More</a>
                 </div>
            </div>
            '; 
        }
    }

    return $output;
}
function fn_show_sliders()
{
    return show_sliders();
}
add_shortcode('show_sliders', 'fn_show_sliders');

/*
 *  To give access to administrator
 */

//$admin_role = get_role( 'administrator' ); 
//$admin_role->add_cap( 'create_auction', true );


add_action("wp_ajax_enquiry_form_action", "enquiry_form_submit");
add_action("wp_ajax_nopriv_enquiry_form_action", "enquiry_form_submit");

function enquiry_form_submit()
{
    exit;
    global $wpdb; 
    $table_name = $wpdb->prefix . 'enquiry_forms';
    $data = $_POST['data']; 
    parse_str($data, $enqueryArr); 

    $auction_id = (isset($enqueryArr['auction_id']) && !empty($enqueryArr['auction_id']))?$enqueryArr['auction_id']:'';
    $user_name = (isset($enqueryArr['user_name']) && !empty($enqueryArr['user_name']))?$enqueryArr['user_name']:'';
    $user_mobile = (isset($enqueryArr['user_mobile']) && !empty($enqueryArr['user_mobile']))?$enqueryArr['user_mobile']:'';
    $user_email = (isset($enqueryArr['user_email']) && !empty($enqueryArr['user_email']))?$enqueryArr['user_email']:'';
    $user_message = (isset($enqueryArr['user_message']) && !empty($enqueryArr['user_message']))?$enqueryArr['user_message']:'';     

    $data = array(
    'auction_id' => $auction_id,
    'user_name' => $user_name,
    'user_mobile' => $user_mobile,
    'user_email' => $user_email,
    'user_message' => $user_message
    );  
 
    $wpdb->insert($table_name, $data);  

    $selectQuery = "SELECT name FROM {$wpdb->prefix}wpa_auctions WHERE id = $auction_id";
    $auction_result = $wpdb->get_results($selectQuery, ARRAY_A);

    $auction_name = (isset($auction_result['name']) && !empty($auction_result['name']))?$auction_result['name']:''; 

    // Send email
        $to = 'ajay.r@broadwayinfotech.com';  //atul.halarnkar@sealthedeal.co.in
        $subject = 'New Enquiry';
        $message = 'Name: ' . $user_name . "\n" .
                'Mobile: ' . $user_mobile . "\n" .
                'Email: ' . $user_email . "\n" .
                'Auction Name: ' . $auction_name . "\n" .
                'Message: ' . $user_message;
        $headers = array('Content-Type: text/html; charset=UTF-8');

        if (wp_mail($to, $subject, $message, $headers)) {
            wp_send_json_success('Enquiry submitted successfully. Email sent.');
        } else {
            wp_send_json_error('Enquiry submitted successfully. Failed to send email.');
        }

}

add_action( 'um_custom_field_validation_user_email_details', 'um_custom_validate_user_email_details', 999, 3 );
function um_custom_validate_user_email_details( $key, $array, $args ) {
	if ( $key == 'user_email' && isset( $args['user_email'] ) ) {
		if ( isset( UM()->form()->errors['user_email'] ) ) {
			unset( UM()->form()->errors['user_email'] );
		}
		if ( empty( $args['user_email'] ) ) {
			UM()->form()->add_error( 'user_email', __( 'E-mail Address is required', 'ultimate-member' ) );
		} elseif ( ! is_email( $args['user_email'] ) ) {
			UM()->form()->add_error( 'user_email', __( 'The email you entered is invalid', 'ultimate-member' ) );
		} elseif ( email_exists( $args['user_email'] ) ) {
			UM()->form()->add_error( 'user_email', __( 'The email you entered is already registered', 'ultimate-member' ) );
		}
	}
} 

function getAuctionLocations(){
    global $wpdb; 
 
    $selectQuery = "SELECT DISTINCT shipping_from FROM {$wpdb->prefix}wpa_auctions WHERE shipping_from !=''";
    $auction_location_result = $wpdb->get_results($selectQuery, ARRAY_A);

    return $auction_location_result;
}
 