<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

 $profile_id = um_profile_id();
?> 
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <link href="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/favicon.png" rel="icon">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous"> 

    <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/bootstrap.css" />
    <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/owl.carousel.min.css" />
    <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/fontawesome-pro-6/css/all.min.css" />
    <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/style.css" />
    <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/lightbox/css/lightbox.min.css" />
 
   <?php wp_head(); ?>    
</head>

<body <?php body_class(); ?>>
    <header>
        <div class="header-navigation py-4">
          <div class="container">
            <div class="d-flex align-items-center justify-content-between">
              <div class="logo">
                <a href="<?php echo home_url(); ?>"
                  ><figure class="mb-0"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/Untitled-2.jpg" alt="CompanyLogo" class="img-fluid"></figure
                ></a>
              </div>
              <div class="d-flex align-items-center">
                <nav class="main-nav">
                  <?php  
                    $args = array(
                    'container'      => '',
                    'theme_location' => 'primary', 
                    'menu_class'     => 'd-lg-flex pb-0  fz16 mb-0  ', 
                    'walker'         => new Custom_Walker_Nav_Menu()
                    ); 
                    wp_nav_menu($args);
                  ?>
                </nav>
           
              <div class="d-flex align-items-center main-nav">
              <ul class="d-flex mb-0 user align-items-center">             
                <li class="d-none d-md-block"><a href="<?php echo home_url('sell-your-product') ?>" class="btn bg-mycolor my-nav-btn" >Sell your product</a></li>
              </ul>
              <div onclick="this.classList.toggle('open'); document.querySelector('.header-navigation nav').classList.toggle('active');" class="menubar d-lg-none ms-3">
                <span></span>
                <span></span>
                <span></span>
              </div>
            </div>
        </div>
            </div>
          </div>
        </div>
      </header>
  

   

   

   