<?php
get_header();

$profile_id =  um_profile_id();   

$bidder_list = [];

if($profile_id !== 0){
    $loginUserData = get_userdata($profile_id); 

    global $wpdb;  
    
    $bidder_list = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT auctions.*,posts.guid AS blog_image_url, bids.bidder_name,count(bids.id) as total_bids FROM {$wpdb->prefix}wpa_auctions AS auctions  INNER JOIN {$wpdb->prefix}posts  AS posts ON auctions.image_url = posts.ID LEFT JOIN {$wpdb->prefix}wpa_bids AS bids ON  auctions.id = bids.auction_id WHERE bids.bidder_email = %s GROUP BY auctions.id",
            $loginUserData->data->user_email
        ),
        ARRAY_A
    ); 
}
?> 
 
<section id="auction-list">
<div class="container">
        <div class="col-md-12 text-center"><h2>Auction List</h2></div>
        <div class="card">  
            <div class="card-body">           
                <div class="row py-4 border-bottom fs-16"> 
                        <div class="col-md-2"><strong>#</strong></div>
                        <div class="col-md-2 "><strong>Title</strong></div>
                        <div class="col-md-2 "><strong>Bidder Name</strong></div>
                        <div class="col-md-2"><strong>Bid Amount</strong></div>
                        <div class="col-md-2"><strong>Total Bids</strong></div>
                        <div class="col-md-2"><strong>Bid Date</strong></div>
                </div> 
                <?php
                if (!empty($bidder_list)) {
                    $total_bidders = count($bidder_list);
                    foreach ($bidder_list as $key => $bidder) {
                    $date_end = strtotime($bidder['date_end']); 

                    $border_class = ($key !== ($total_bidders - 1)) ? 'border-bottom' : '';
                ?> 
                <div class="row py-4 <?php echo $border_class; ?> fs-16">
                        <div class="col-md-2"><?php echo $key+1 ?></div>
                        <div class="col-md-2"><?php echo esc_html($bidder['name']); ?></div>
                        <div class="col-md-2"><?php echo esc_html($bidder['bidder_name']); ?></div>
                        <div class="col-md-2"><?php echo esc_html($bidder['current_price']); ?></div>
                        <div class="col-md-2"><?php echo esc_html($bidder['total_bids']); ?></div>
                        <div class="col-md-2"><?php echo date('jS, F, Y', $date_end); ?></div>
                </div> 
                <?php } }else{ ?>
                    <div class="row py-4 <?php echo $border_class; ?> fs-16">  
                        <div class="col-md-12 text-center">Record Not Found</div>
                    </div> 
                <?php }  ?>
        </div>
    </div>
</div>
</section>
<?php get_footer();?>